/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx__thread.c,v 1.13 2006/09/14 23:03:44 eugene Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__thread.h"
#include "mx__shim.h"

#if MX_THREAD_SAFE

#if (MX_OS_LINUX || MX_OS_FREEBSD || MX_OS_MACOSX || MX_OS_SOLARIS || MX_OS_UDRV)

MX__MUTEX_T Mx_lock = PTHREAD_MUTEX_INITIALIZER;
MX__MUTEX_T Mx_rcache_lock = PTHREAD_MUTEX_INITIALIZER;

#elif MX_OS_WINNT

MX__MUTEX_T Mx_lock;
MX__MUTEX_T Mx_rcache_lock;

typedef struct thread_t
{
  void *(*start_routine)(void*);
  void *arg;
} thread_t;

unsigned __stdcall
mx__thread_create_helper(void* p)
{
  thread_t* t;
  
  t = (thread_t*) p;
  t->start_routine(t->arg);
  return 0;
}

int
mx__thread_create(mx__thread_t *thread, void *(*start_routine)(void *),
		  void *arg)
{
  unsigned thrdaddr;
  DWORD dwAffinityMask;

  
  thread->ti = (struct mx__threadinfo_t*)mx_malloc(sizeof (*thread->ti));
  thread->ti->start_routine = start_routine;
  thread->ti->arg = arg;
  thread->thread = (HANDLE)_beginthreadex(NULL, 0, 
					  mx__thread_create_helper,
					  thread->ti, 0, &thrdaddr);

  if (getenv ("MX_ENABLE_AFFINITY")) {
    int num_cpu;
    char buff[80];
    num_cpu = atoi (getenv ("MX_ENABLE_AFFINITY"));
    dwAffinityMask = (DWORD) num_cpu;
    if (!SetThreadAffinityMask (thread->thread,
                                (DWORD_PTR)dwAffinityMask)) {
      sprintf(buff, "SetProcessAffinityMask: %d\n", GetLastError());
      OutputDebugString (buff);
    }
    // Give the CPU the time to reschedule
    Sleep (0);
  }

  return 0;
}

int
mx__thread_join(mx__thread_t *t, void **thread_return)
{
  WaitForSingleObject(t->thread, INFINITE);
  mx_free(t->ti);
  return 0;
}

void
mx__thread_exit(void *retval)
{
  _endthreadex(0);
}

unsigned long
mx__thread_self(void)
{
  return (unsigned long)GetCurrentThreadId();
}

#else
#error no thread support for this OS
#endif

#else

typedef int foo;

#endif
